<?php

/**
 *
 * Let's Review Shortcodes Class
 *
 * @since      2.0.0
 *
 * @package    Let's Review
 * @subpackage lets-review/frontend
 */

class Lets_Review_Shortcodes {

	/**
	 * Var for slug.
	 *
	 * @since    1.0.0
	 */
	private $slug;

	/**
	 * Var for version.
	 *
	 * @since    1.0.0
	 */
	private $version;

	/**
	 * Var for URL.
	 *
	 * @since    1.0.0
	 */
	private $url;

	/**
	 * Constructor
	 *
	 * @since 1.0.0
	 *
	*/
	public function __construct( $slug = '', $version = '', $url = '' ) {
		$this->slug    = $slug;
		$this->version = $version;
		$this->url     = $url;
	}

	/**
	 * Shortcode output
	 *
	 * @since 1.0.0
	 * @return Review output
	 */
	public function lets_review_shortcode( $atts = array(), $content = '' ) {
		global $post;
		$atts = empty( $atts ) ? array() : $atts;

		if ( ! isset( $atts['postid'] ) ) {
			$atts['postid'] = $post->ID;
		}

		if ( empty( $atts['postid'] ) ) {
			return;
		}

		if ( get_post_meta( $atts['postid'], '_lets_review_onoff', true ) != 1 ) {
			return;
		}
		$frontend = new Lets_Review_Frontend( $this->slug, $this->version, $this->url );
		return $frontend->lets_review_new_review_box(
			array(
				'pid'    => $atts['postid'],
				'schema' => empty( $atts['schema'] ) ? '' : $atts['schema'],
			)
		);
	}

	/**
	 * Shortcode list output
	 *
	 * @since 1.2.0
	 * @return Review output
	 */
	public function lets_review_shortcode_list( $atts = array(), $content = '' ) {

		if ( empty( $atts['postid'] ) && ! isset( $atts['cats'] ) && ! isset( $atts['tags'] ) ) {
			return;
		}
		$args                = array();
		$args['design']      = isset( $atts['design'] ) ? $atts['design'] : 1;
		$args['design']      = 'modern' === $atts['design'] ? 2 : 1;
		$args['order']       = isset( $atts['order'] ) ? $atts['order'] : 1;
		$args['source']      = isset( $atts['source'] ) ? $atts['source'] : 1;
		$args['type']        = isset( $atts['type'] ) ? $atts['type'] : 1;
		$args['cats']        = isset( $atts['cats'] ) ? $atts['cats'] : '';
		$args['ppp']         = isset( $atts['ppp'] ) ? $atts['ppp'] : '';
		$args['tags']        = isset( $atts['tags'] ) ? $atts['tags'] : '';
		$args['title']       = isset( $atts['title'] ) ? $atts['title'] : '';
		$args['pids']        = isset( $atts['postid'] ) ? $atts['postid'] : '';
		$args['countdown']   = isset( $atts['countdown'] ) ? $atts['countdown'] : true;
		$args['prosconsOff'] = isset( $atts['proscons'] ) && 'off' == $atts['proscons'] ? true : '';
		return Lets_Review_Blocks::lets_review_list( $args );
	}

	/**
	 * Shortcode affiliate button
	 *
	 * @since 1.2.0
	 * @return Review output
	 */
	public function lets_review_shortcode_affiliate( $atts, $content = '' ) {

		if ( empty( $atts ) ) {
			return;
		}

		$color     = ! empty( $atts['accent'] ) ? $atts['accent'] : '#f8d92f';
		$url       = ! empty( $atts['url'] ) ? $atts['url'] : '';
		$text      = ! empty( $atts['text'] ) ? $atts['text'] : '';
		$border    = ! empty( $atts['border'] ) ? $atts['border'] : 'on';
		$alignment = ! empty( $atts['textalign'] ) ? $atts['textalign'] : 'center';
		$rel       = ! empty( $atts['rel'] ) ? $atts['rel'] : 'noreferrer noopener nofollow';
		$animation = ! empty( $atts['animation'] ) ? $atts['animation'] : 1;
		$target    = ! empty( $atts['target'] ) && $atts['target'] == 'samewindow' ? '_self' : '_blank';
		$size      = ! empty( $atts['size'] ) && $atts['size'] == 'big' ? ' lr-button-big' : ' lr-button-small';
		$classes   = 'lets-review-block__wrap_80';
		$classes  .= 'off' == $border ? ' lets-review-button--border--off' : '';
		$classes  .= 'center' == $alignment ? ' lets-review-button--center' : '';

		$output = '<div class="' . esc_attr( $classes ) . '">';
		if ( isset( $atts['maintitle'] ) ) {
			$output .= '<div class="aff-title lr-font-h">' . $atts['maintitle'] . '</diV>';
		}
		$output .= '<a href="' . esc_url( $url ) . '" rel="' . esc_attr( $rel ) . '" target="' . esc_attr( $target ) . '" class="aff-button lr-button' . esc_attr( $size ) . '">';
		$output .= '<span class="button-title">' . $text . '</span>';
		$output .= '<div class="i-wrap" style="background-color: ' . esc_attr( $color ) . ';">';
		$output .= get_option( 'lets_review_gen_type_shopping_onoff' ) == 1 ? '<div class="custom-shopping-icon cb-button-ani-1">' . get_option( 'lets_review_gen_type_shopping_icon' ) . '</div>' : '<i class="' . esc_attr( apply_filters( 'lets_review_aff_icon_1_class', '' ) ) . 'fas fa-shopping-cart cb-button-ani-' . intval( $animation ) . '"></i>';
		$output .= '<i class="fas fa-long-arrow-alt-right cb-button-ani-' . intval( $animation ) . '-hid cb-button-ani-' . intval( $animation ) . '"></i></div></a>';
		$output .= '</div>';
		return $output;

	}

	/**
	 * Shortcode unique button
	 *
	 * @since 2.0.0
	 * @return Review output
	 */
	public function lets_review_shortcode_unique( $atts = array(), $content = '' ) {
		if ( empty( $atts ) ) {
			return;
		}
		$args          = array();
		$args['crits'] = array();
		if ( ! empty( $atts['criterias'] ) ) {
			$crits = explode( apply_filters( 'lets_review_backend_delimiter', ',' ), $atts['criterias'] );
			foreach ( $crits as $key => $value ) {
				if ( 0 == $key % 2 ) {
					$args['crits'][ $key ] = array(
						'title' => $value,
					);
				} else {
					$args['crits'][ $key - 1 ]['score'] = $value;
				}
			}
		}
		$args['affBlocks'] = array();
		if ( ! empty( $atts['affiliate'] ) ) {
			$args['affBlocks'] = Lets_Review_Helpers::lets_review_cleanup_aff( $atts['affiliate'] );
		}
		if ( ! empty( $atts['gallery'] ) ) {
			$gallery = explode( apply_filters( 'lets_review_backend_delimiter', ',' ), $atts['gallery'] );
			foreach ( $gallery as $key => $value ) {
				$gallery[ $key ] = array(
					'id' => $value,
				);
			}
		}
		$args['aniType']         = empty( $atts['animation'] ) ? '' : $atts['animation'];
		$args['scoreType']       = empty( $atts['format'] ) ? '' : $atts['format'];
		$args['score']           = isset( $atts['final_score'] ) && '' !== $atts['final_score'] ? Lets_Review_Helpers::lets_review_get_convert_to_all_scores(
			array(
				'score'     => $atts['final_score'],
				'scoreType' => 1,
			)
		) : '';
		$args['crits']           = Lets_Review_Helpers::lets_review_get_convert_to_all_scores(
			array(
				'score'     => $args['crits'],
				'scoreType' => 1,
			)
		);
		$args['pros']            = isset( $atts['pros'] ) ? Lets_Review_Helpers::lets_review_cleanup_pros_cons( $atts['pros'] ) : '';
		$args['cons']            = isset( $atts['cons'] ) ? Lets_Review_Helpers::lets_review_cleanup_pros_cons( $atts['cons'] ) : '';
		$args['skin']            = empty( $atts['skin'] ) ? '' : $atts['skin'];
		$args['uid']             = 123;
		$args['fiID']            = empty( $atts['main_image'] ) ? '' : $atts['main_image'];
		$args['accent']          = empty( $atts['accent'] ) ? '' : $atts['accent'];
		$args['consTitle']       = empty( $atts['cons_title'] ) ? '' : $atts['cons_title'];
		$args['prosTitle']       = empty( $atts['pros_title'] ) ? '' : $atts['pros_title'];
		$args['gallery']         = empty( $gallery ) ? '' : $gallery;
		$args['galleryTitle']    = empty( $atts['gallery-title'] ) ? '' : $atts['gallery-title'];
		$args['design']          = empty( $atts['design'] ) ? '' : $atts['design'];
		$args['title']           = empty( $atts['title'] ) ? '' : $atts['title'];
		$args['affTitle']        = empty( $atts['affiliate_title'] ) ? '' : $atts['affiliate_title'];
		$args['scoreTitle']      = empty( $atts['score_subtitle'] ) ? '' : $atts['score_subtitle'];
		$args['iconCode']        = ! isset( $atts['icon_code'] ) ? '' : html_entity_decode( $atts['icon_code'] );
		$args['conclusionTitle'] = empty( $atts['conclusion_title'] ) ? '' : $atts['conclusion_title'];
		$args['conclusion']      = empty( $content ) ? '' : $content;
		$args['sc']              = true;
		if ( $args['design'] > 2 ) {
			$args['bgID'] = $args['fiID'];
			$args['fiID'] = '';
		}
		return Lets_Review_Blocks::lets_review_block( $args );
	}

	/**
	 * Shortcode user rating
	 *
	 * @since 3.0.0
	 * @return Review output
	 */
	public function lets_review_shortcode_user_rating( $atts, $content = '' ) {

		if ( empty( $atts['id'] ) ) {
			return esc_html__( 'Missing ID attribute.', 'lets-review' );
		}

		$pid              = empty( $atts['postid'] ) ? '' : $atts['postid'];
		$uid              = empty( $atts['id'] ) ? '' : $atts['id'];
		$skin             = empty( $atts['skin'] ) ? '' : $atts['skin'];
		$format           = empty( $atts['format'] ) ? '' : $atts['format'];
		$design           = empty( $atts['design'] ) ? '' : $atts['design'];
		$conclusion_title = empty( $atts['content_title'] ) ? '' : $atts['content_title'];
		$title            = empty( $atts['title'] ) ? '' : $atts['title'];
		$score_box        = empty( $atts['score_box'] ) ? '' : $atts['score_box'];
		$image            = empty( $atts['image'] ) ? '' : $atts['image'];
		$atts['content']  = empty( $content ) ? '' : $content;
		$args             = array(
			'uid'             => $uid,
			'sc_pid'          => $pid,
			'skin'            => $skin,
			'format'          => $format,
			'title'           => $title,
			'fiID'            => $image,
			'conclusion'      => $content,
			'conclusionTitle' => $conclusion_title,
			'show_score_box'  => $score_box,
		);
		return Lets_Review_Blocks::lets_review_visitor_rating_block( $args );

	}

	/**
	 * Shortcode user rating
	 *
	 * @since 3.1.7
	 * @return Review output
	 */
	public function lets_review_shortcode_comment_averages( $atts, $content = '' ) {

		if ( empty( $atts['postid'] ) ) {
			return esc_html__( 'Missing postid attribute.', 'lets-review' );
		}

		$args = array(
			'title'      => empty( $atts['title'] ) ? '' : $atts['title'],
			'bgID'       => empty( $atts['backgroundimage'] ) ? '' : $atts['backgroundimage'],
			'pid'        => empty( $atts['postid'] ) ? '' : $atts['postid'],
			'design'     => empty( $atts['design'] ) ? '1' : $atts['design'],
			'skin'       => empty( $atts['skin'] ) ? '1' : $atts['skin'],
			'skinBG'     => empty( $atts['backgroundcolor'] ) ? '#111' : $atts['backgroundcolor'],
			'skinText'   => empty( $atts['textcolor'] ) ? '#111' : $atts['textcolor'],
			'skinTitles' => empty( $atts['titlescolor'] ) ? '#111' : $atts['titlescolor'],
			'accent'     => empty( $atts['accent'] ) ? '#f8d92f' : $atts['accent'],
		);
		return Lets_Review_Blocks::lets_review_comment_averages_block( $args );

	}

	/**
	 * Shortcode user comments review final score
	 *
	 * @since 3.2.0
	 * @return Review score output
	 */
	public function lets_review_shortcode_comment_averages_final_score( $atts, $content = '' ) {

		if ( empty( $atts['postid'] ) ) {
			return esc_html__( 'Missing postid attribute.', 'lets-review' );
		}
		$score = Lets_Review_Blocks::lets_review_comment_averages_final_score( array( 'pid' => $atts['postid'] ) );
		if ( empty( $score['score'] ) ) {
			return;
		}
		$format = empty( $score['format'] ) ? 1 : $score['format'];
		if ( 1 == $format ) {
			$score = $score['score']['outof100'] . '%';
		} elseif ( 2 == $format ) {
			$score = $score['score']['outof10'];
		} else {
			$score = $score['score']['outouf5'];
		}
		return $score;

	}

}
